CREATE WIDGET-POOL.

DEFINE TEMP-TABLE customer
    FIELD NAME AS CHAR FIELD bin AS INT
    INDEX bybib bin ASCENDING.
     
DEF VAR collation AS CHAR.

DEFINE VAR C-Win AS WIDGET-HANDLE NO-UNDO.

DEFINE BUTTON BUTTON-1 LABEL "Quit" SIZE 10 BY 1.2.

DEFINE VARIABLE COMBO-BOX-1 AS CHARACTER FORMAT "X(256)":U 
     LABEL "Collation" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     LIST-ITEMS "Item 1","item 2","item 3" 
     DROP-DOWN-LIST  SIZE 25 BY 1 NO-UNDO.

DEFINE QUERY BROWSE-1 FOR Customer FIELDS (NAME) SCROLLING.

DEFINE BROWSE BROWSE-1  QUERY BROWSE-1 NO-LOCK 
    DISPLAY
      Customer.Name COLUMN-LABEL "My Sorted Sordid Data" FORMAT "x(50)":U
    WITH NO-ROW-MARKERS SEPARATORS SIZE 35 BY 10 EXPANDABLE TITLE "Sorted Data".

DEFINE FRAME DEFAULT-FRAME
     COMBO-BOX-1 AT ROW 2 COL 15 COLON-ALIGNED
     BUTTON-1 AT ROW 2 COL 55  BROWSE-1 AT ROW 5 COL 35
    WITH 1 DOWN NO-BOX KEEP-TAB-ORDER OVERLAY 
         SIDE-LABELS NO-UNDERLINE THREE-D 
         AT COL 1 ROW 1    SIZE 80 BY 16
         DEFAULT-BUTTON BUTTON-1 CANCEL-BUTTON BUTTON-1.

CREATE WINDOW C-Win ASSIGN
     HIDDEN             = YES
     TITLE              = "Demonstrate Collate Phrase"
     HEIGHT             = 16  WIDTH  = 80
     MAX-HEIGHT         = 16  MAX-WIDTH = 80
     VIRTUAL-HEIGHT     = 16  VIRTUAL-WIDTH = 80
     RESIZE             = yes
     SCROLL-BARS        = NO  STATUS-AREA = no
     BGCOLOR            = ?   FGCOLOR = ?
     KEEP-FRAME-Z-ORDER = YES  THREE-D = yes
     MESSAGE-AREA       = NO   SENSITIVE = yes.

IF SESSION:DISPLAY-TYPE = "GUI":U AND VALID-HANDLE(C-Win)
THEN C-Win:HIDDEN = no.

ON END-ERROR OF C-Win OR ENDKEY OF C-Win ANYWHERE DO:
END.

ON WINDOW-CLOSE OF C-Win DO:
  APPLY "CLOSE":U TO THIS-PROCEDURE.
  RETURN NO-APPLY.
END.

ON CHOOSE OF BUTTON-1 IN FRAME DEFAULT-FRAME /* Quit */ DO:
  APPLY "WINDOW-CLOSE" TO c-win.
END.

ON VALUE-CHANGED OF COMBO-BOX-1 IN FRAME DEFAULT-FRAME /* Select a collation */
DO:
  ASSIGN collation = combo-box-1:SCREEN-VALUE.
  RUN disp-names. /* change query */
END.

ASSIGN CURRENT-WINDOW                = C-Win
       THIS-PROCEDURE:CURRENT-WINDOW = C-Win.

ON CLOSE OF THIS-PROCEDURE 
   RUN disable_UI.

PAUSE 0 BEFORE-HIDE.

DEF VAR i AS INT.
DO i = 65 TO 255:    /* populate the temp-table */
    IF i > 127 AND i < 160 THEN NEXT.
    CREATE customer.
    ASSIGN NAME = "    " + CHR(i) + "   -" + STRING(i, "999    ") + CHR(i)
        bin = i.
END.

MAIN-BLOCK:
DO ON ERROR   UNDO MAIN-BLOCK, LEAVE MAIN-BLOCK
   ON END-KEY UNDO MAIN-BLOCK, LEAVE MAIN-BLOCK:
   RUN enable_UI.
   WAIT-FOR CLOSE OF THIS-PROCEDURE.
END.

PROCEDURE disable_UI :
  IF SESSION:DISPLAY-TYPE = "GUI":U AND VALID-HANDLE(C-Win)
  THEN DELETE WIDGET C-Win.
END PROCEDURE.

PROCEDURE enable_UI :
  ASSIGN  /* initialize the collation combo-box */
      combo-box-1:LIST-ITEMS  IN FRAME DEFAULT-FRAME  = "Binary," + GET-COLLATIONS(SESSION:CPINTERNAL)
      combo-box-1:SCREEN-VALUE  IN FRAME DEFAULT-FRAME  = SESSION:CPCOLL.
      collation = SESSION:CPCOLL.
  DISPLAY COMBO-BOX-1 
      WITH FRAME DEFAULT-FRAME IN WINDOW C-Win.
  ENABLE COMBO-BOX-1 BUTTON-1 BROWSE-1 
      WITH FRAME DEFAULT-FRAME IN WINDOW C-Win.
 RUN disp-names.
  VIEW C-Win.
END PROCEDURE.

PROCEDURE disp-names.
    /* disp-names resets the browse to use new collation.
    If the collation is binary, the strength is changed to RAW to
    cause a binary collation to be used. Otherwise the collation table
    named in the VAR collation sets the sort ordering.*/
    DEF VAR strength AS CHAR.
    IF collation ="Binary" THEN strength = "RAW".
       ELSE strength = "CASE-INSENSITIVE".

    OPEN QUERY browse-1 
        FOR EACH customer NO-LOCK BY COLLATE(name, strength , collation).
END PROCEDURE.
